//
//  OPApplication.m
//  The Obfuscated Path
//
//  Created by ss2cire on 12/5/08.
//  Copyright 2008 GryphonClaw Software. All rights reserved.
//

#import "OPApplication.h"
#import "OPTypes.h"
#import "OPMasterController.h"
#import "OPMenuController.h"


@implementation OPApplication
- (id)init
{
	self = [super init];
	if(self != nil)
	{
		srandom(time(NULL));
	}
	return self;
}

- (void)sendEvent:(NSEvent *)event
{
	if (([self keyWindow] != [self mainWindow]))
	{
		[super sendEvent: event];
		return;
	}
	
    switch ([event type])
	{
		case NSLeftMouseDown:
			[masterController mouseDown: event];
			[super sendEvent: event];
			break;
		case NSLeftMouseUp:
			[masterController mouseUp: event];
			[super sendEvent: event];
			break;
		case NSMouseMoved:
			[masterController mouseMoved: event];
			[super sendEvent: event];
			break;
		case NSLeftMouseDragged:
			[masterController mouseDragged: event];
			[super sendEvent: event];
			break;
		case NSKeyDown:
			if ([event modifierFlags] & NSCommandKeyMask) {
				[super sendEvent: event];
				break;
			}
			[masterController keyDown: event];
			break;
		case NSKeyUp:
			if ([event modifierFlags] & NSCommandKeyMask) {
				[super sendEvent: event];
				break;
			}
			[masterController keyUp: event];
			break;
		default:
			[super sendEvent: event];
			break;
	}
}

- (void)setMasterController:(id)controller
{
	masterController = controller;
}

- (void)loadTileMap
{
	NSString *tileMapPath = [[NSBundle mainBundle] pathForResource:@"Tile Map" ofType:@"plist"];
	if(tileMapPath != nil) {
		tileTranslationMap = [[NSDictionary alloc] initWithContentsOfFile:tileMapPath];
	}
}

- (NSDictionary *)tileMap
{
	return tileTranslationMap;
}

- (void)loadEnemyMap
{
	NSString *enemyMapPath = [[NSBundle mainBundle] pathForResource:@"Enemy Map" ofType:@"plist"];
	if(enemyMapPath != nil) {
		enemyTranslationMap = [[NSArray alloc] initWithContentsOfFile:enemyMapPath];
	}
}

- (NSArray *)enemyMap
{
	return enemyTranslationMap;
}

- (void)setPlayer:(id)inPlayer
{
	[[masterController gameController] setPlayer:inPlayer];
}

- (id)player
{
	return [[masterController gameController] player];
}
@end
